@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.AzureStackEdgeDeviceResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an Azure Stack Edge device resource.
 * @property id Azure Stack Edge device resource ID.
 */
public data class AzureStackEdgeDeviceResourceIdArgs(
    public val id: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.AzureStackEdgeDeviceResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.AzureStackEdgeDeviceResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.AzureStackEdgeDeviceResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStackEdgeDeviceResourceIdArgs].
 */
@PulumiTagMarker
public class AzureStackEdgeDeviceResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure Stack Edge device resource ID.
     */
    @JvmName("hmdfpdoiwfetfugn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Stack Edge device resource ID.
     */
    @JvmName("daqveujfuhkckquu")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AzureStackEdgeDeviceResourceIdArgs = AzureStackEdgeDeviceResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
