@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.AzureStackHCIClusterResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an Azure Stack HCI cluster resource.
 * @property id Azure Stack HCI cluster resource ID.
 */
public data class AzureStackHCIClusterResourceIdArgs(
    public val id: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.AzureStackHCIClusterResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.AzureStackHCIClusterResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.AzureStackHCIClusterResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStackHCIClusterResourceIdArgs].
 */
@PulumiTagMarker
public class AzureStackHCIClusterResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure Stack HCI cluster resource ID.
     */
    @JvmName("bcpaettpgaebtefo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Stack HCI cluster resource ID.
     */
    @JvmName("qswjiyrwbilpmtph")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): AzureStackHCIClusterResourceIdArgs = AzureStackHCIClusterResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
