@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetDataNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataNetworkName The name of the data network.
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataNetworkPlainArgs(
    public val dataNetworkName: String,
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetDataNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetDataNetworkPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetDataNetworkPlainArgs.builder()
            .dataNetworkName(dataNetworkName.let({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetDataNetworkPlainArgsBuilder internal constructor() {
    private var dataNetworkName: String? = null

    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the data network.
     */
    @JvmName("iwyapwhwxxplfntj")
    public suspend fun dataNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataNetworkName = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("fdtxppyfjkbwfpnw")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("olunaleandhlhycy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataNetworkPlainArgs = GetDataNetworkPlainArgs(
        dataNetworkName = dataNetworkName ?: throw PulumiNullFieldException("dataNetworkName"),
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
