@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetDiagnosticsPackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diagnosticsPackageName The name of the diagnostics package.
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDiagnosticsPackagePlainArgs(
    public val diagnosticsPackageName: String,
    public val packetCoreControlPlaneName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetDiagnosticsPackagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetDiagnosticsPackagePlainArgs = com.pulumi.azurenative.mobilenetwork.inputs.GetDiagnosticsPackagePlainArgs.builder()
        .diagnosticsPackageName(diagnosticsPackageName.let({ args0 -> args0 }))
        .packetCoreControlPlaneName(packetCoreControlPlaneName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiagnosticsPackagePlainArgs].
 */
@PulumiTagMarker
public class GetDiagnosticsPackagePlainArgsBuilder internal constructor() {
    private var diagnosticsPackageName: String? = null

    private var packetCoreControlPlaneName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the diagnostics package.
     */
    @JvmName("oylnpsqvlrmkusdt")
    public suspend fun diagnosticsPackageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diagnosticsPackageName = mapped
    }

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("ysfwkxdiuxlygjaf")
    public suspend fun packetCoreControlPlaneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iqntbcrcjaiyafqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiagnosticsPackagePlainArgs = GetDiagnosticsPackagePlainArgs(
        diagnosticsPackageName = diagnosticsPackageName ?: throw
            PulumiNullFieldException("diagnosticsPackageName"),
        packetCoreControlPlaneName = packetCoreControlPlaneName ?: throw
            PulumiNullFieldException("packetCoreControlPlaneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
