@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCoreControlPlanePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property packetCoreControlPlaneName The name of the packet core control plane.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPacketCoreControlPlanePlainArgs(
    public val packetCoreControlPlaneName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCoreControlPlanePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCoreControlPlanePlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.GetPacketCoreControlPlanePlainArgs.builder()
            .packetCoreControlPlaneName(packetCoreControlPlaneName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPacketCoreControlPlanePlainArgs].
 */
@PulumiTagMarker
public class GetPacketCoreControlPlanePlainArgsBuilder internal constructor() {
    private var packetCoreControlPlaneName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the packet core control plane.
     */
    @JvmName("jorfpojpmajctvfm")
    public suspend fun packetCoreControlPlaneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCoreControlPlaneName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xjsmafnwbmibhhvw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPacketCoreControlPlanePlainArgs = GetPacketCoreControlPlanePlainArgs(
        packetCoreControlPlaneName = packetCoreControlPlaneName ?: throw
            PulumiNullFieldException("packetCoreControlPlaneName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
