@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Interface properties
 * @property ipv4Address The IPv4 address.
 * @property ipv4Gateway The default IPv4 gateway (router).
 * @property ipv4Subnet The IPv4 subnet.
 * @property name The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
 */
public data class InterfacePropertiesArgs(
    public val ipv4Address: Output<String>? = null,
    public val ipv4Gateway: Output<String>? = null,
    public val ipv4Subnet: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.InterfacePropertiesArgs.builder()
            .ipv4Address(ipv4Address?.applyValue({ args0 -> args0 }))
            .ipv4Gateway(ipv4Gateway?.applyValue({ args0 -> args0 }))
            .ipv4Subnet(ipv4Subnet?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InterfacePropertiesArgs].
 */
@PulumiTagMarker
public class InterfacePropertiesArgsBuilder internal constructor() {
    private var ipv4Address: Output<String>? = null

    private var ipv4Gateway: Output<String>? = null

    private var ipv4Subnet: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The IPv4 address.
     */
    @JvmName("fhlocsvfgwjogian")
    public suspend fun ipv4Address(`value`: Output<String>) {
        this.ipv4Address = value
    }

    /**
     * @param value The default IPv4 gateway (router).
     */
    @JvmName("ujiexgltmomeisou")
    public suspend fun ipv4Gateway(`value`: Output<String>) {
        this.ipv4Gateway = value
    }

    /**
     * @param value The IPv4 subnet.
     */
    @JvmName("ujbqfhddgrymbcsq")
    public suspend fun ipv4Subnet(`value`: Output<String>) {
        this.ipv4Subnet = value
    }

    /**
     * @param value The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
     */
    @JvmName("ufcsbewyiiffmesb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IPv4 address.
     */
    @JvmName("qdugnkcqttsvkxnu")
    public suspend fun ipv4Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Address = mapped
    }

    /**
     * @param value The default IPv4 gateway (router).
     */
    @JvmName("cmbhueuaffvgdtyk")
    public suspend fun ipv4Gateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Gateway = mapped
    }

    /**
     * @param value The IPv4 subnet.
     */
    @JvmName("uigqsrasexfbgkht")
    public suspend fun ipv4Subnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4Subnet = mapped
    }

    /**
     * @param value The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
     */
    @JvmName("uypqfrlmwfvgrgna")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): InterfacePropertiesArgs = InterfacePropertiesArgs(
        ipv4Address = ipv4Address,
        ipv4Gateway = ipv4Gateway,
        ipv4Subnet = ipv4Subnet,
        name = name,
    )
}
