@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMobileNetworkSimGroupsPlainArgs(
    public val mobileNetworkName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimGroupsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimGroupsPlainArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.ListMobileNetworkSimGroupsPlainArgs.builder()
            .mobileNetworkName(mobileNetworkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMobileNetworkSimGroupsPlainArgs].
 */
@PulumiTagMarker
public class ListMobileNetworkSimGroupsPlainArgsBuilder internal constructor() {
    private var mobileNetworkName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("dqmmnvquecyxdrtj")
    public suspend fun mobileNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ikobyhldcnlvkhfr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMobileNetworkSimGroupsPlainArgs = ListMobileNetworkSimGroupsPlainArgs(
        mobileNetworkName = mobileNetworkName ?: throw PulumiNullFieldException("mobileNetworkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
