@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PinholeTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
 * @property icmp Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
 * @property tcp Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
 * @property udp Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
 */
public data class PinholeTimeoutsArgs(
    public val icmp: Output<Int>? = null,
    public val tcp: Output<Int>? = null,
    public val udp: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PinholeTimeoutsArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PinholeTimeoutsArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PinholeTimeoutsArgs.builder()
            .icmp(icmp?.applyValue({ args0 -> args0 }))
            .tcp(tcp?.applyValue({ args0 -> args0 }))
            .udp(udp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PinholeTimeoutsArgs].
 */
@PulumiTagMarker
public class PinholeTimeoutsArgsBuilder internal constructor() {
    private var icmp: Output<Int>? = null

    private var tcp: Output<Int>? = null

    private var udp: Output<Int>? = null

    /**
     * @param value Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
     */
    @JvmName("uctrjdxfsavvdxdi")
    public suspend fun icmp(`value`: Output<Int>) {
        this.icmp = value
    }

    /**
     * @param value Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
     */
    @JvmName("tixhbeniimfaofva")
    public suspend fun tcp(`value`: Output<Int>) {
        this.tcp = value
    }

    /**
     * @param value Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
     */
    @JvmName("beiqfrligebtolio")
    public suspend fun udp(`value`: Output<Int>) {
        this.udp = value
    }

    /**
     * @param value Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
     */
    @JvmName("qquwublqkbqhfqlt")
    public suspend fun icmp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmp = mapped
    }

    /**
     * @param value Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
     */
    @JvmName("hggidcmbueosqctc")
    public suspend fun tcp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param value Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
     */
    @JvmName("veejhaqohqgryoep")
    public suspend fun udp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udp = mapped
    }

    internal fun build(): PinholeTimeoutsArgs = PinholeTimeoutsArgs(
        icmp = icmp,
        tcp = tcp,
        udp = udp,
    )
}
