@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SliceResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a slice resource.
 * @property id Slice resource ID.
 */
public data class SliceResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SliceResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SliceResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SliceResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SliceResourceIdArgs].
 */
@PulumiTagMarker
public class SliceResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Slice resource ID.
     */
    @JvmName("orqqonkeispwcewd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Slice resource ID.
     */
    @JvmName("atvydcvgdcrbrmlp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SliceResourceIdArgs = SliceResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
