@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Aggregate maximum bit rate.
 * @property downlink Downlink bit rate.
 * @property uplink Uplink bit rate.
 */
public data class AmbrResponse(
    public val downlink: String,
    public val uplink: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.AmbrResponse): AmbrResponse = AmbrResponse(
            downlink = javaType.downlink(),
            uplink = javaType.uplink(),
        )
    }
}
