@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Settings controlling data network use
 * @property additionalAllowedSessionTypes Allowed session types in addition to the default session type. Must not duplicate the default session type.
 * @property allocationAndRetentionPriorityLevel Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemptionCapability` and `preemptionVulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `5qi` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property allowedServices List of services that can be used as part of this SIM policy. The list must not contain duplicate items and must contain at least one item. The services must be in the same location as the SIM policy.
 * @property dataNetwork A reference to the data network that these settings apply to. The data network must be in the same location as the SIM policy.
 * @property defaultSessionType The default PDU session type, which is used if the UE does not request a specific session type.
 * @property fiveQi Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
 * @property maximumNumberOfBufferedPackets The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
 * @property preemptionCapability Default QoS Flow preemption capability. The preemption capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property preemptionVulnerability Default QoS Flow preemption vulnerability. The preemption vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
 * @property sessionAmbr Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
 */
public data class DataNetworkConfigurationResponse(
    public val additionalAllowedSessionTypes: List<String>? = null,
    public val allocationAndRetentionPriorityLevel: Int? = null,
    public val allowedServices: List<ServiceResourceIdResponse>,
    public val dataNetwork: DataNetworkResourceIdResponse,
    public val defaultSessionType: String? = null,
    public val fiveQi: Int? = null,
    public val maximumNumberOfBufferedPackets: Int? = null,
    public val preemptionCapability: String? = null,
    public val preemptionVulnerability: String? = null,
    public val sessionAmbr: AmbrResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.DataNetworkConfigurationResponse): DataNetworkConfigurationResponse = DataNetworkConfigurationResponse(
            additionalAllowedSessionTypes = javaType.additionalAllowedSessionTypes().map({ args0 -> args0 }),
            allocationAndRetentionPriorityLevel = javaType.allocationAndRetentionPriorityLevel().map({ args0 ->
                args0
            }).orElse(null),
            allowedServices = javaType.allowedServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ServiceResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            dataNetwork = javaType.dataNetwork().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DataNetworkResourceIdResponse.Companion.toKotlin(args0)
            }),
            defaultSessionType = javaType.defaultSessionType().map({ args0 -> args0 }).orElse(null),
            fiveQi = javaType.fiveQi().map({ args0 -> args0 }).orElse(null),
            maximumNumberOfBufferedPackets = javaType.maximumNumberOfBufferedPackets().map({ args0 ->
                args0
            }).orElse(null),
            preemptionCapability = javaType.preemptionCapability().map({ args0 -> args0 }).orElse(null),
            preemptionVulnerability = javaType.preemptionVulnerability().map({ args0 -> args0 }).orElse(null),
            sessionAmbr = javaType.sessionAmbr().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
