@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Attached data network resource. Must be created in the same location as its parent packet core data plane.
 * @property dnsAddresses The DNS servers to signal to UEs to use for this attached data network. This configuration is mandatory - if you don't want DNS servers, you must provide an empty array.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property naptConfiguration The network address and port translation (NAPT) configuration.
 * If this is not specified, the attached data network will use a default NAPT configuration with NAPT enabled.
 * @property provisioningState The provisioning state of the attached data network resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userEquipmentAddressPoolPrefix The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will dynamically assign IP addresses to UEs.
 * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
 *  You must define at least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
 * @property userEquipmentStaticAddressPoolPrefix The user equipment (UE) address pool prefixes for the attached data network from which the packet core instance will assign static IP addresses to UEs.
 * The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM resource.
 * At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must be defined. If both are defined, they must be of the same size.
 * @property userPlaneDataInterface The user plane interface on the data network. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
 */
public data class GetAttachedDataNetworkResult(
    public val dnsAddresses: List<String>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val naptConfiguration: NaptConfigurationResponse? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userEquipmentAddressPoolPrefix: List<String>? = null,
    public val userEquipmentStaticAddressPoolPrefix: List<String>? = null,
    public val userPlaneDataInterface: InterfacePropertiesResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetAttachedDataNetworkResult): GetAttachedDataNetworkResult = GetAttachedDataNetworkResult(
            dnsAddresses = javaType.dnsAddresses().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            naptConfiguration = javaType.naptConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.NaptConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userEquipmentAddressPoolPrefix = javaType.userEquipmentAddressPoolPrefix().map({ args0 -> args0 }),
            userEquipmentStaticAddressPoolPrefix = javaType.userEquipmentStaticAddressPoolPrefix().map({ args0 ->
                args0
            }),
            userPlaneDataInterface = javaType.userPlaneDataInterface().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
