@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Diagnostics package resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the diagnostics package resource.
 * @property reason The reason for the current state of the diagnostics package collection.
 * @property status The status of the diagnostics package collection.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDiagnosticsPackageResult(
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val reason: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetDiagnosticsPackageResult): GetDiagnosticsPackageResult = GetDiagnosticsPackageResult(
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            reason = javaType.reason(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
