@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Packet capture session resource.
 * @property bytesToCapturePerPacket Number of bytes captured per packet, the remaining bytes are truncated. The default "0" means the entire packet is captured.
 * @property captureStartTime The start time of the packet capture session.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property networkInterfaces List of network interfaces to capture on.
 * @property provisioningState The provisioning state of the packet capture session resource.
 * @property reason The reason the current packet capture session state.
 * @property status The status of the packet capture session.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property timeLimitInSeconds Maximum duration of the capture session in seconds.
 * @property totalBytesPerSession Maximum size of the capture output.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPacketCaptureResult(
    public val bytesToCapturePerPacket: Double? = null,
    public val captureStartTime: String,
    public val id: String,
    public val name: String,
    public val networkInterfaces: List<String>? = null,
    public val provisioningState: String,
    public val reason: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val timeLimitInSeconds: Int? = null,
    public val totalBytesPerSession: Double? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetPacketCaptureResult): GetPacketCaptureResult = GetPacketCaptureResult(
            bytesToCapturePerPacket = javaType.bytesToCapturePerPacket().map({ args0 -> args0 }).orElse(null),
            captureStartTime = javaType.captureStartTime(),
            id = javaType.id(),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            reason = javaType.reason(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeLimitInSeconds = javaType.timeLimitInSeconds().map({ args0 -> args0 }).orElse(null),
            totalBytesPerSession = javaType.totalBytesPerSession().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
