@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SIM policy resource.
 * @property defaultSlice The default slice to use if the UE does not explicitly specify it. This slice must exist in the `sliceConfigurations` map. The slice must be in the same location as the SIM policy.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the SIM policy resource.
 * @property registrationTimer UE periodic registration update timer (5G) or UE periodic tracking area update timer (4G), in seconds.
 * @property rfspIndex RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an optional setting and by default is unspecified.
 * @property siteProvisioningState A dictionary of sites to the provisioning state of this SIM policy on that site.
 * @property sliceConfigurations The allowed slices and the settings to use for them. The list must not contain duplicate items and must contain at least one item.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property ueAmbr Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
 */
public data class GetSimPolicyResult(
    public val defaultSlice: SliceResourceIdResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val registrationTimer: Int? = null,
    public val rfspIndex: Int? = null,
    public val siteProvisioningState: Map<String, String>,
    public val sliceConfigurations: List<SliceConfigurationResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val ueAmbr: AmbrResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetSimPolicyResult): GetSimPolicyResult = GetSimPolicyResult(
            defaultSlice = javaType.defaultSlice().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceResourceIdResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            registrationTimer = javaType.registrationTimer().map({ args0 -> args0 }).orElse(null),
            rfspIndex = javaType.rfspIndex().map({ args0 -> args0 }).orElse(null),
            siteProvisioningState = javaType.siteProvisioningState().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            sliceConfigurations = javaType.sliceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            ueAmbr = javaType.ueAmbr().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AmbrResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
