@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * SIM resource.
 * @property deviceType An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property integratedCircuitCardIdentifier The integrated circuit card ID (ICCID) for the SIM.
 * @property internationalMobileSubscriberIdentity The international mobile subscriber identity (IMSI) for the SIM.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the SIM resource.
 * @property simPolicy The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
 * @property simState The state of the SIM resource.
 * @property siteProvisioningState A dictionary of sites to the provisioning state of this SIM on that site.
 * @property staticIpConfiguration A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vendorKeyFingerprint The public key fingerprint of the SIM vendor who provided this SIM, if any.
 * @property vendorName The name of the SIM vendor who provided this SIM, if any.
 */
public data class GetSimResult(
    public val deviceType: String? = null,
    public val id: String,
    public val integratedCircuitCardIdentifier: String? = null,
    public val internationalMobileSubscriberIdentity: String,
    public val name: String,
    public val provisioningState: String,
    public val simPolicy: SimPolicyResourceIdResponse? = null,
    public val simState: String,
    public val siteProvisioningState: Map<String, String>,
    public val staticIpConfiguration: List<SimStaticIpPropertiesResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val vendorKeyFingerprint: String,
    public val vendorName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetSimResult): GetSimResult = GetSimResult(
            deviceType = javaType.deviceType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            integratedCircuitCardIdentifier = javaType.integratedCircuitCardIdentifier().map({ args0 ->
                args0
            }).orElse(null),
            internationalMobileSubscriberIdentity = javaType.internationalMobileSubscriberIdentity(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            simPolicy = javaType.simPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimPolicyResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            simState = javaType.simState(),
            siteProvisioningState = javaType.siteProvisioningState().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            staticIpConfiguration = javaType.staticIpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimStaticIpPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            vendorKeyFingerprint = javaType.vendorKeyFingerprint(),
            vendorName = javaType.vendorName(),
        )
    }
}
