@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * HTTPS server certificate configuration.
 * @property certificateUrl The certificate URL, unversioned. For example: https://contosovault.vault.azure.net/certificates/ingress.
 * @property provisioning The provisioning state of the certificate.
 */
public data class HttpsServerCertificateResponse(
    public val certificateUrl: String,
    public val provisioning: CertificateProvisioningResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.HttpsServerCertificateResponse): HttpsServerCertificateResponse = HttpsServerCertificateResponse(
            certificateUrl = javaType.certificateUrl(),
            provisioning = javaType.provisioning().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.CertificateProvisioningResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
