@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Interface properties
 * @property ipv4Address The IPv4 address.
 * @property ipv4Gateway The default IPv4 gateway (router).
 * @property ipv4Subnet The IPv4 subnet.
 * @property name The logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
 */
public data class InterfacePropertiesResponse(
    public val ipv4Address: String? = null,
    public val ipv4Gateway: String? = null,
    public val ipv4Subnet: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.InterfacePropertiesResponse): InterfacePropertiesResponse = InterfacePropertiesResponse(
            ipv4Address = javaType.ipv4Address().map({ args0 -> args0 }).orElse(null),
            ipv4Gateway = javaType.ipv4Gateway().map({ args0 -> args0 }).orElse(null),
            ipv4Subnet = javaType.ipv4Subnet().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
