@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for list SIM groups API service call.
 * @property nextLink The URL to get the next set of results.
 * @property value A list of SIM groups in a resource group.
 */
public data class ListMobileNetworkSimGroupsResult(
    public val nextLink: String,
    public val `value`: List<SimGroupResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.ListMobileNetworkSimGroupsResult): ListMobileNetworkSimGroupsResult = ListMobileNetworkSimGroupsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimGroupResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
