@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for list SIM IDs API service call.
 * @property nextLink The URL to get the next set of results.
 * @property value A list of SIM IDs.
 */
public data class ListMobileNetworkSimIdsResult(
    public val nextLink: String,
    public val `value`: List<SubResourceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.ListMobileNetworkSimIdsResult): ListMobileNetworkSimIdsResult = ListMobileNetworkSimIdsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
