@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The network address and port translation settings to use for the attached data network.
 * @property enabled Whether NAPT is enabled for connections to this attached data network.
 * @property pinholeLimits Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
 * @property pinholeTimeouts Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
 * @property portRange Range of port numbers to use as translated ports on each translated address.
 * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
 * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
 * @property portReuseHoldTime The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at least 1 second.
 */
public data class NaptConfigurationResponse(
    public val enabled: String? = null,
    public val pinholeLimits: Int? = null,
    public val pinholeTimeouts: PinholeTimeoutsResponse? = null,
    public val portRange: PortRangeResponse? = null,
    public val portReuseHoldTime: PortReuseHoldTimesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.NaptConfigurationResponse): NaptConfigurationResponse = NaptConfigurationResponse(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            pinholeLimits = javaType.pinholeLimits().map({ args0 -> args0 }).orElse(null),
            pinholeTimeouts = javaType.pinholeTimeouts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PinholeTimeoutsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            portRange = javaType.portRange().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PortRangeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            portReuseHoldTime = javaType.portReuseHoldTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PortReuseHoldTimesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
