@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Public land mobile network (PLMN) ID.
 * @property mcc Mobile country code (MCC).
 * @property mnc Mobile network code (MNC).
 */
public data class PlmnIdResponse(
    public val mcc: String,
    public val mnc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PlmnIdResponse): PlmnIdResponse = PlmnIdResponse(
            mcc = javaType.mcc(),
            mnc = javaType.mnc(),
        )
    }
}
