@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
 * @property tcp Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
 * @property udp Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
 */
public data class PortReuseHoldTimesResponse(
    public val tcp: Int? = null,
    public val udp: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.PortReuseHoldTimesResponse): PortReuseHoldTimesResponse = PortReuseHoldTimesResponse(
            tcp = javaType.tcp().map({ args0 -> args0 }).orElse(null),
            udp = javaType.udp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
