@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Suppress

/**
 * Static IP configuration for a SIM, scoped to a particular attached data network and slice.
 * @property attachedDataNetwork The attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The attached data network must be in the same location as the SIM.
 * @property slice The network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address. The slice must be in the same location as the SIM.
 * @property staticIp The static IP configuration for the SIM to use at the defined network scope.
 */
public data class SimStaticIpPropertiesResponse(
    public val attachedDataNetwork: AttachedDataNetworkResourceIdResponse? = null,
    public val slice: SliceResourceIdResponse? = null,
    public val staticIp: SimStaticIpPropertiesResponseStaticIp? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.SimStaticIpPropertiesResponse): SimStaticIpPropertiesResponse = SimStaticIpPropertiesResponse(
            attachedDataNetwork = javaType.attachedDataNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.AttachedDataNetworkResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            slice = javaType.slice().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SliceResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            staticIp = javaType.staticIp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimStaticIpPropertiesResponseStaticIp.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
