@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin as operationalStatusResponseToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AmfDeployment].
 */
@PulumiTagMarker
public class AmfDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmfDeploymentArgs = AmfDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmfDeploymentArgsBuilder.() -> Unit) {
        val builder = AmfDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AmfDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.mobilepacketcore.AmfDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AmfDeployment(builtJavaResource)
    }
}

/**
 * Azure for Operators 5G Core Access and Mobility Function (AMF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### AmfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var amfDeployment = new AzureNative.MobilePacketCore.AmfDeployment("amfDeployment", new()
 *     {
 *         AmfDeploymentName = "amfDeployment1",
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewAmfDeployment(ctx, "amfDeployment", &mobilepacketcore.AmfDeploymentArgs{
 * 			AmfDeploymentName:   pulumi.String("amfDeployment1"),
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.AmfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.AmfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var amfDeployment = new AmfDeployment("amfDeployment", AmfDeploymentArgs.builder()
 *             .amfDeploymentName("amfDeployment1")
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:AmfDeployment amfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/amfDeployments/{amfDeploymentName}
 * ```
 */
public class AmfDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilepacketcore.AmfDeployment,
) : KotlinCustomResource(javaResource, AmfDeploymentMapper) {
    /**
     * Reference to cluster where the Network Function is deployed
     */
    public val clusterService: Output<String>
        get() = javaResource.clusterService().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core AMF component parameters
     */
    public val componentParameters: Output<String>?
        get() = javaResource.componentParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operational status
     */
    public val operationalStatus: Output<OperationalStatusResponse>
        get() = javaResource.operationalStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                operationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Release version. This is inherited from the cluster
     */
    public val releaseVersion: Output<String>
        get() = javaResource.releaseVersion().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core AMF secrets parameters
     */
    public val secretsParameters: Output<String>?
        get() = javaResource.secretsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AmfDeploymentMapper : ResourceMapper<AmfDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilepacketcore.AmfDeployment::class == javaResource::class

    override fun map(javaResource: Resource): AmfDeployment = AmfDeployment(
        javaResource as
            com.pulumi.azurenative.mobilepacketcore.AmfDeployment,
    )
}

/**
 * @see [AmfDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AmfDeployment].
 */
public suspend fun amfDeployment(
    name: String,
    block: suspend AmfDeploymentResourceBuilder.() -> Unit,
): AmfDeployment {
    val builder = AmfDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AmfDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun amfDeployment(name: String): AmfDeployment {
    val builder = AmfDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
