@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceAksClusterDataResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceNexusAksClusterDataResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.QualifiedComponentDeploymentParametersResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin as operationalStatusResponseToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.QualifiedComponentDeploymentParametersResponse.Companion.toKotlin as qualifiedComponentDeploymentParametersResponseToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ClusterService].
 */
@PulumiTagMarker
public class ClusterServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterServiceArgs = ClusterServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterServiceArgsBuilder.() -> Unit) {
        val builder = ClusterServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterService {
        val builtJavaResource =
            com.pulumi.azurenative.mobilepacketcore.ClusterService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClusterService(builtJavaResource)
    }
}

/**
 * Azure for Operators 5G Core Cluster Service Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### ClusterServices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var clusterService = new AzureNative.MobilePacketCore.ClusterService("clusterService", new()
 *     {
 *         ClusterServiceName = "clusterService1",
 *         ClusterTypeSpecificData = new AzureNative.MobilePacketCore.Inputs.ClusterServiceNexusAksClusterDataArgs
 *         {
 *             CustomLocationId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location",
 *             Type = "NexusAks",
 *         },
 *         ComponentParameters = new[]
 *         {
 *             new AzureNative.MobilePacketCore.Inputs.QualifiedComponentDeploymentParametersArgs
 *             {
 *                 Parameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *                 Secrets = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *                 Type = "fed-crds",
 *             },
 *         },
 *         DeploymentType = AzureNative.MobilePacketCore.SkuDeploymentType.Production,
 *         Location = "eastus",
 *         ReleaseVersion = "4.3.0-alpha",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewClusterService(ctx, "clusterService", &mobilepacketcore.ClusterServiceArgs{
 * 			ClusterServiceName: pulumi.String("clusterService1"),
 * 			ClusterTypeSpecificData: mobilepacketcore.ClusterServiceNexusAksClusterData{
 * 				CustomLocationId: "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location",
 * 				Type:             "NexusAks",
 * 			},
 * 			ComponentParameters: mobilepacketcore.QualifiedComponentDeploymentParametersArray{
 * 				&mobilepacketcore.QualifiedComponentDeploymentParametersArgs{
 * 					Parameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 					Secrets:    pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 					Type:       pulumi.String("fed-crds"),
 * 				},
 * 			},
 * 			DeploymentType:    pulumi.String(mobilepacketcore.SkuDeploymentTypeProduction),
 * 			Location:          pulumi.String("eastus"),
 * 			ReleaseVersion:    pulumi.String("4.3.0-alpha"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.ClusterService;
 * import com.pulumi.azurenative.mobilepacketcore.ClusterServiceArgs;
 * import com.pulumi.azurenative.mobilepacketcore.inputs.QualifiedComponentDeploymentParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var clusterService = new ClusterService("clusterService", ClusterServiceArgs.builder()
 *             .clusterServiceName("clusterService1")
 *             .clusterTypeSpecificData(ClusterServiceNexusAksClusterDataArgs.builder()
 *                 .customLocationId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cluster124Location")
 *                 .type("NexusAks")
 *                 .build())
 *             .componentParameters(QualifiedComponentDeploymentParametersArgs.builder()
 *                 .parameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *                 .secrets("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *                 .type("fed-crds")
 *                 .build())
 *             .deploymentType("Production")
 *             .location("eastus")
 *             .releaseVersion("4.3.0-alpha")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:ClusterService clusterService1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/clusterServices/{clusterServiceName}
 * ```
 */
public class ClusterService internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilepacketcore.ClusterService,
) : KotlinCustomResource(javaResource, ClusterServiceMapper) {
    /**
     * Cluster type specific data.  Contents depend on the cluster type
     */
    public val clusterTypeSpecificData:
        Output<Either<ClusterServiceAksClusterDataResponse, ClusterServiceNexusAksClusterDataResponse>>
        get() = javaResource.clusterTypeSpecificData().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceAksClusterDataResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.ClusterServiceNexusAksClusterDataResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Azure for Operators 5G Core Local PaaS component parameters.  One set per component type
     */
    public val componentParameters: Output<List<QualifiedComponentDeploymentParametersResponse>>
        get() = javaResource.componentParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> qualifiedComponentDeploymentParametersResponseToKotlin(args0) })
            })
        })

    /**
     * Cluster type (Lab or Production)
     */
    public val deploymentType: Output<String>
        get() = javaResource.deploymentType().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operational status
     */
    public val operationalStatus: Output<OperationalStatusResponse>
        get() = javaResource.operationalStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                operationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core Release Version.  This is applied to all platform as a service (PaaS) components and running workloads in this cluster
     */
    public val releaseVersion: Output<String>
        get() = javaResource.releaseVersion().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ClusterServiceMapper : ResourceMapper<ClusterService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilepacketcore.ClusterService::class == javaResource::class

    override fun map(javaResource: Resource): ClusterService = ClusterService(
        javaResource as
            com.pulumi.azurenative.mobilepacketcore.ClusterService,
    )
}

/**
 * @see [ClusterService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterService].
 */
public suspend fun clusterService(
    name: String,
    block: suspend ClusterServiceResourceBuilder.() -> Unit,
): ClusterService {
    val builder = ClusterServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterService(name: String): ClusterService {
    val builder = ClusterServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
