@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getAmfDeploymentPlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getClusterServicePlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getNetworkFunctionPlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getNrfDeploymentPlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getNssfDeploymentPlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getObservabilityServicePlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getSmfDeploymentPlain
import com.pulumi.azurenative.mobilepacketcore.MobilepacketcoreFunctions.getUpfDeploymentPlain
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetAmfDeploymentPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetAmfDeploymentPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetClusterServicePlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetClusterServicePlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNetworkFunctionPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNetworkFunctionPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNrfDeploymentPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNrfDeploymentPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNssfDeploymentPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetNssfDeploymentPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetObservabilityServicePlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetObservabilityServicePlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetSmfDeploymentPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetSmfDeploymentPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetUpfDeploymentPlainArgs
import com.pulumi.azurenative.mobilepacketcore.kotlin.inputs.GetUpfDeploymentPlainArgsBuilder
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetAmfDeploymentResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetClusterServiceResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNetworkFunctionResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNrfDeploymentResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNssfDeploymentResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetObservabilityServiceResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetSmfDeploymentResult
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetUpfDeploymentResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetAmfDeploymentResult.Companion.toKotlin as getAmfDeploymentResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetClusterServiceResult.Companion.toKotlin as getClusterServiceResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNetworkFunctionResult.Companion.toKotlin as getNetworkFunctionResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNrfDeploymentResult.Companion.toKotlin as getNrfDeploymentResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetNssfDeploymentResult.Companion.toKotlin as getNssfDeploymentResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetObservabilityServiceResult.Companion.toKotlin as getObservabilityServiceResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetSmfDeploymentResult.Companion.toKotlin as getSmfDeploymentResultToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.GetUpfDeploymentResult.Companion.toKotlin as getUpfDeploymentResultToKotlin

public object MobilepacketcoreFunctions {
    /**
     * Get a AmfDeploymentResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Access and Mobility Function (AMF) Deployment Resource
     */
    public suspend fun getAmfDeployment(argument: GetAmfDeploymentPlainArgs): GetAmfDeploymentResult =
        getAmfDeploymentResultToKotlin(getAmfDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getAmfDeployment].
     * @param amfDeploymentName The name of the AMF Deployment
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure for Operators 5G Core Access and Mobility Function (AMF) Deployment Resource
     */
    public suspend fun getAmfDeployment(amfDeploymentName: String, resourceGroupName: String): GetAmfDeploymentResult {
        val argument = GetAmfDeploymentPlainArgs(
            amfDeploymentName = amfDeploymentName,
            resourceGroupName = resourceGroupName,
        )
        return getAmfDeploymentResultToKotlin(getAmfDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmfDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetAmfDeploymentPlainArgs].
     * @return Azure for Operators 5G Core Access and Mobility Function (AMF) Deployment Resource
     */
    public suspend fun getAmfDeployment(argument: suspend GetAmfDeploymentPlainArgsBuilder.() -> Unit): GetAmfDeploymentResult {
        val builder = GetAmfDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmfDeploymentResultToKotlin(getAmfDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ClusterServiceResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Cluster Service Resource
     */
    public suspend fun getClusterService(argument: GetClusterServicePlainArgs): GetClusterServiceResult =
        getClusterServiceResultToKotlin(getClusterServicePlain(argument.toJava()).await())

    /**
     * @see [getClusterService].
     * @param clusterServiceName The name of the Cluster Service
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure for Operators 5G Core Cluster Service Resource
     */
    public suspend fun getClusterService(clusterServiceName: String, resourceGroupName: String): GetClusterServiceResult {
        val argument = GetClusterServicePlainArgs(
            clusterServiceName = clusterServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterServiceResultToKotlin(getClusterServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetClusterServicePlainArgs].
     * @return Azure for Operators 5G Core Cluster Service Resource
     */
    public suspend fun getClusterService(argument: suspend GetClusterServicePlainArgsBuilder.() -> Unit): GetClusterServiceResult {
        val builder = GetClusterServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterServiceResultToKotlin(getClusterServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a NetworkFunctionResource
     * Azure REST API version: 2023-05-15-preview.
     * @param argument null
     * @return AO5GC Network Function Resource
     */
    public suspend fun getNetworkFunction(argument: GetNetworkFunctionPlainArgs): GetNetworkFunctionResult =
        getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkFunction].
     * @param networkFunctionName The name of the network function
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return AO5GC Network Function Resource
     */
    public suspend fun getNetworkFunction(networkFunctionName: String, resourceGroupName: String): GetNetworkFunctionResult {
        val argument = GetNetworkFunctionPlainArgs(
            networkFunctionName = networkFunctionName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkFunction].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetNetworkFunctionPlainArgs].
     * @return AO5GC Network Function Resource
     */
    public suspend fun getNetworkFunction(argument: suspend GetNetworkFunctionPlainArgsBuilder.() -> Unit): GetNetworkFunctionResult {
        val builder = GetNetworkFunctionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkFunctionResultToKotlin(getNetworkFunctionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a NrfDeploymentResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Network Repository Function (NRF) Deployment Resource
     */
    public suspend fun getNrfDeployment(argument: GetNrfDeploymentPlainArgs): GetNrfDeploymentResult =
        getNrfDeploymentResultToKotlin(getNrfDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getNrfDeployment].
     * @param nrfDeploymentName The name of the NrfDeployment
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure for Operators 5G Core Network Repository Function (NRF) Deployment Resource
     */
    public suspend fun getNrfDeployment(nrfDeploymentName: String, resourceGroupName: String): GetNrfDeploymentResult {
        val argument = GetNrfDeploymentPlainArgs(
            nrfDeploymentName = nrfDeploymentName,
            resourceGroupName = resourceGroupName,
        )
        return getNrfDeploymentResultToKotlin(getNrfDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getNrfDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetNrfDeploymentPlainArgs].
     * @return Azure for Operators 5G Core Network Repository Function (NRF) Deployment Resource
     */
    public suspend fun getNrfDeployment(argument: suspend GetNrfDeploymentPlainArgsBuilder.() -> Unit): GetNrfDeploymentResult {
        val builder = GetNrfDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNrfDeploymentResultToKotlin(getNrfDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a NssfDeploymentResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Network Slice Selection Function (NSSF) Deployment Resource
     */
    public suspend fun getNssfDeployment(argument: GetNssfDeploymentPlainArgs): GetNssfDeploymentResult =
        getNssfDeploymentResultToKotlin(getNssfDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getNssfDeployment].
     * @param nssfDeploymentName The name of the NssfDeployment
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure for Operators 5G Core Network Slice Selection Function (NSSF) Deployment Resource
     */
    public suspend fun getNssfDeployment(nssfDeploymentName: String, resourceGroupName: String): GetNssfDeploymentResult {
        val argument = GetNssfDeploymentPlainArgs(
            nssfDeploymentName = nssfDeploymentName,
            resourceGroupName = resourceGroupName,
        )
        return getNssfDeploymentResultToKotlin(getNssfDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getNssfDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetNssfDeploymentPlainArgs].
     * @return Azure for Operators 5G Core Network Slice Selection Function (NSSF) Deployment Resource
     */
    public suspend fun getNssfDeployment(argument: suspend GetNssfDeploymentPlainArgsBuilder.() -> Unit): GetNssfDeploymentResult {
        val builder = GetNssfDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNssfDeploymentResultToKotlin(getNssfDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ObservabilityServiceResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Observability Service Resource
     */
    public suspend fun getObservabilityService(argument: GetObservabilityServicePlainArgs): GetObservabilityServiceResult =
        getObservabilityServiceResultToKotlin(getObservabilityServicePlain(argument.toJava()).await())

    /**
     * @see [getObservabilityService].
     * @param observabilityServiceName The name of the Observability Service
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure for Operators 5G Core Observability Service Resource
     */
    public suspend fun getObservabilityService(
        observabilityServiceName: String,
        resourceGroupName: String,
    ): GetObservabilityServiceResult {
        val argument = GetObservabilityServicePlainArgs(
            observabilityServiceName = observabilityServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getObservabilityServiceResultToKotlin(getObservabilityServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getObservabilityService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetObservabilityServicePlainArgs].
     * @return Azure for Operators 5G Core Observability Service Resource
     */
    public suspend fun getObservabilityService(argument: suspend GetObservabilityServicePlainArgsBuilder.() -> Unit): GetObservabilityServiceResult {
        val builder = GetObservabilityServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getObservabilityServiceResultToKotlin(getObservabilityServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SmfDeploymentResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core Session Management Function (SMF) Deployment Resource
     */
    public suspend fun getSmfDeployment(argument: GetSmfDeploymentPlainArgs): GetSmfDeploymentResult =
        getSmfDeploymentResultToKotlin(getSmfDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getSmfDeployment].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param smfDeploymentName The name of the SmfDeployment
     * @return Azure for Operators 5G Core Session Management Function (SMF) Deployment Resource
     */
    public suspend fun getSmfDeployment(resourceGroupName: String, smfDeploymentName: String): GetSmfDeploymentResult {
        val argument = GetSmfDeploymentPlainArgs(
            resourceGroupName = resourceGroupName,
            smfDeploymentName = smfDeploymentName,
        )
        return getSmfDeploymentResultToKotlin(getSmfDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getSmfDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetSmfDeploymentPlainArgs].
     * @return Azure for Operators 5G Core Session Management Function (SMF) Deployment Resource
     */
    public suspend fun getSmfDeployment(argument: suspend GetSmfDeploymentPlainArgsBuilder.() -> Unit): GetSmfDeploymentResult {
        val builder = GetSmfDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSmfDeploymentResultToKotlin(getSmfDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a UpfDeploymentResource
     * Azure REST API version: 2023-10-15-preview.
     * @param argument null
     * @return Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
     */
    public suspend fun getUpfDeployment(argument: GetUpfDeploymentPlainArgs): GetUpfDeploymentResult =
        getUpfDeploymentResultToKotlin(getUpfDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getUpfDeployment].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param upfDeploymentName The name of the UpfDeployment
     * @return Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
     */
    public suspend fun getUpfDeployment(resourceGroupName: String, upfDeploymentName: String): GetUpfDeploymentResult {
        val argument = GetUpfDeploymentPlainArgs(
            resourceGroupName = resourceGroupName,
            upfDeploymentName = upfDeploymentName,
        )
        return getUpfDeploymentResultToKotlin(getUpfDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getUpfDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;mobilepacketcore&#46;kotlin&#46;inputs&#46;GetUpfDeploymentPlainArgs].
     * @return Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
     */
    public suspend fun getUpfDeployment(argument: suspend GetUpfDeploymentPlainArgsBuilder.() -> Unit): GetUpfDeploymentResult {
        val builder = GetUpfDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUpfDeploymentResultToKotlin(getUpfDeploymentPlain(builtArgument.toJava()).await())
    }
}
