@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkFunction].
 */
@PulumiTagMarker
public class NetworkFunctionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkFunctionArgs = NetworkFunctionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkFunctionArgsBuilder.() -> Unit) {
        val builder = NetworkFunctionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkFunction {
        val builtJavaResource =
            com.pulumi.azurenative.mobilepacketcore.NetworkFunction(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkFunction(builtJavaResource)
    }
}

/**
 * AO5GC Network Function Resource
 * Azure REST API version: 2023-05-15-preview.
 * ## Example Usage
 * ### NetworkFunctions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkFunction = new AzureNative.MobilePacketCore.NetworkFunction("networkFunction", new()
 *     {
 *         Capacity = 100000,
 *         DeploymentNotes = "string",
 *         Location = "eastus",
 *         NetworkFunctionAdministrativeState = AzureNative.MobilePacketCore.NetworkFunctionAdministrativeState.Commissioned,
 *         NetworkFunctionName = "nf1",
 *         NetworkFunctionType = AzureNative.MobilePacketCore.NetworkFunctionType.SMF,
 *         ResourceGroupName = "rg1",
 *         Sku = AzureNative.MobilePacketCore.SkuDefinitions.NexusProduction,
 *         UserDescription = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewNetworkFunction(ctx, "networkFunction", &mobilepacketcore.NetworkFunctionArgs{
 * 			Capacity:                           pulumi.Int(100000),
 * 			DeploymentNotes:                    pulumi.String("string"),
 * 			Location:                           pulumi.String("eastus"),
 * 			NetworkFunctionAdministrativeState: pulumi.String(mobilepacketcore.NetworkFunctionAdministrativeStateCommissioned),
 * 			NetworkFunctionName:                pulumi.String("nf1"),
 * 			NetworkFunctionType:                pulumi.String(mobilepacketcore.NetworkFunctionTypeSMF),
 * 			ResourceGroupName:                  pulumi.String("rg1"),
 * 			Sku:                                pulumi.String(mobilepacketcore.SkuDefinitionsNexusProduction),
 * 			UserDescription:                    pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.NetworkFunction;
 * import com.pulumi.azurenative.mobilepacketcore.NetworkFunctionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkFunction = new NetworkFunction("networkFunction", NetworkFunctionArgs.builder()
 *             .capacity(100000)
 *             .deploymentNotes("string")
 *             .location("eastus")
 *             .networkFunctionAdministrativeState("Commissioned")
 *             .networkFunctionName("nf1")
 *             .networkFunctionType("SMF")
 *             .resourceGroupName("rg1")
 *             .sku("NexusProduction")
 *             .userDescription("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:NetworkFunction nf1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/networkFunctions/{networkFunctionName}
 * ```
 */
public class NetworkFunction internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilepacketcore.NetworkFunction,
) : KotlinCustomResource(javaResource, NetworkFunctionMapper) {
    /**
     * Capacity of the network function in units of 10000.  This represents the session count or the Simultaneously Attached Users (SAU) count as applicable
     */
    public val capacity: Output<Int>?
        get() = javaResource.capacity().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * User provided deployment notes.  This is used to optionally provide details about the NF deployment
     */
    public val deploymentNotes: Output<String>?
        get() = javaResource.deploymentNotes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Count of infrastructure elements used by this network function (vCPUs, in units of 8)
     */
    public val infrastructureElementCount: Output<Int>
        get() = javaResource.infrastructureElementCount().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Administrative state of the network function
     */
    public val networkFunctionAdministrativeState: Output<String>
        get() = javaResource.networkFunctionAdministrativeState().applyValue({ args0 -> args0 })

    /**
     * Operational state of the network function
     */
    public val networkFunctionOperationalStatus: Output<String>
        get() = javaResource.networkFunctionOperationalStatus().applyValue({ args0 -> args0 })

    /**
     * Type of network function
     */
    public val networkFunctionType: Output<String>
        get() = javaResource.networkFunctionType().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Provisioned SKU Value.
     */
    public val sku: Output<String>
        get() = javaResource.sku().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * User provided description
     */
    public val userDescription: Output<String>?
        get() = javaResource.userDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NetworkFunctionMapper : ResourceMapper<NetworkFunction> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilepacketcore.NetworkFunction::class == javaResource::class

    override fun map(javaResource: Resource): NetworkFunction = NetworkFunction(
        javaResource as
            com.pulumi.azurenative.mobilepacketcore.NetworkFunction,
    )
}

/**
 * @see [NetworkFunction].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkFunction].
 */
public suspend fun networkFunction(
    name: String,
    block: suspend NetworkFunctionResourceBuilder.() -> Unit,
): NetworkFunction {
    val builder = NetworkFunctionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkFunction].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkFunction(name: String): NetworkFunction {
    val builder = NetworkFunctionResourceBuilder()
    builder.name(name)
    return builder.build()
}
