@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.NssfDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Network Slice Selection Function (NSSF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### NssfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nssfDeployment = new AzureNative.MobilePacketCore.NssfDeployment("nssfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         NssfDeploymentName = "nssfDeployment1",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewNssfDeployment(ctx, "nssfDeployment", &mobilepacketcore.NssfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			NssfDeploymentName:  pulumi.String("nssfDeployment1"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.NssfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.NssfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nssfDeployment = new NssfDeployment("nssfDeployment", NssfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .nssfDeploymentName("nssfDeployment1")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:NssfDeployment nssfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/nssfDeployments/{nssfDeploymentName}
 * ```
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core NSSF component parameters
 * @property location The geo-location where the resource lives
 * @property nssfDeploymentName The name of the NssfDeployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secretsParameters Azure for Operators 5G Core NSSF secrets parameters
 * @property tags Resource tags.
 */
public data class NssfDeploymentArgs(
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<String>? = null,
    public val location: Output<String>? = null,
    public val nssfDeploymentName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretsParameters: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.NssfDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.NssfDeploymentArgs =
        com.pulumi.azurenative.mobilepacketcore.NssfDeploymentArgs.builder()
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(componentParameters?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .nssfDeploymentName(nssfDeploymentName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretsParameters(secretsParameters?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NssfDeploymentArgs].
 */
@PulumiTagMarker
public class NssfDeploymentArgsBuilder internal constructor() {
    private var clusterService: Output<String>? = null

    private var componentParameters: Output<String>? = null

    private var location: Output<String>? = null

    private var nssfDeploymentName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretsParameters: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("hayimccddpncrhau")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core NSSF component parameters
     */
    @JvmName("kswpwlajfqplpdfl")
    public suspend fun componentParameters(`value`: Output<String>) {
        this.componentParameters = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uwbfcuubtkwwrvsm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the NssfDeployment
     */
    @JvmName("fbgojwvijghsmpsd")
    public suspend fun nssfDeploymentName(`value`: Output<String>) {
        this.nssfDeploymentName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxhptpiwalwwlhya")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure for Operators 5G Core NSSF secrets parameters
     */
    @JvmName("rejqqwqpgjkhkggb")
    public suspend fun secretsParameters(`value`: Output<String>) {
        this.secretsParameters = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jmkycilckudrqgmi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("rtwdqsdwaqfedrkc")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core NSSF component parameters
     */
    @JvmName("qvjaxdfvjkoympxa")
    public suspend fun componentParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nnxyedutfoblaxpu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the NssfDeployment
     */
    @JvmName("hddeidkxjslbvajg")
    public suspend fun nssfDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nssfDeploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxjduipcnqkahojf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure for Operators 5G Core NSSF secrets parameters
     */
    @JvmName("febfupeiavuoheba")
    public suspend fun secretsParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsParameters = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sysqfxanrsnjrjid")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dscqyiugfqavnxoa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NssfDeploymentArgs = NssfDeploymentArgs(
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        nssfDeploymentName = nssfDeploymentName,
        resourceGroupName = resourceGroupName,
        secretsParameters = secretsParameters,
        tags = tags,
    )
}
