@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.SmfDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure for Operators 5G Core Session Management Function (SMF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### SmfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var smfDeployment = new AzureNative.MobilePacketCore.SmfDeployment("smfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *         SmfDeploymentName = "smfDeployment1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewSmfDeployment(ctx, "smfDeployment", &mobilepacketcore.SmfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 			SmfDeploymentName:   pulumi.String("smfDeployment1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.SmfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.SmfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var smfDeployment = new SmfDeployment("smfDeployment", SmfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .smfDeploymentName("smfDeployment1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:SmfDeployment smfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/smfDeployments/{smfDeploymentName}
 * ```
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core SMF component parameters
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property secretsParameters Azure for Operators 5G Core SMF secrets parameters
 * @property smfDeploymentName The name of the SmfDeployment
 * @property tags Resource tags.
 */
public data class SmfDeploymentArgs(
    public val clusterService: Output<String>? = null,
    public val componentParameters: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretsParameters: Output<String>? = null,
    public val smfDeploymentName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.SmfDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.SmfDeploymentArgs =
        com.pulumi.azurenative.mobilepacketcore.SmfDeploymentArgs.builder()
            .clusterService(clusterService?.applyValue({ args0 -> args0 }))
            .componentParameters(componentParameters?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretsParameters(secretsParameters?.applyValue({ args0 -> args0 }))
            .smfDeploymentName(smfDeploymentName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SmfDeploymentArgs].
 */
@PulumiTagMarker
public class SmfDeploymentArgsBuilder internal constructor() {
    private var clusterService: Output<String>? = null

    private var componentParameters: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretsParameters: Output<String>? = null

    private var smfDeploymentName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("eiquvbjdynappnpd")
    public suspend fun clusterService(`value`: Output<String>) {
        this.clusterService = value
    }

    /**
     * @param value Azure for Operators 5G Core SMF component parameters
     */
    @JvmName("cjxygrbfuqgvpslh")
    public suspend fun componentParameters(`value`: Output<String>) {
        this.componentParameters = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xgfgrpygijltbrck")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xhbbpwlhvonuxfgs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure for Operators 5G Core SMF secrets parameters
     */
    @JvmName("ytvssnkqdwjtcdxu")
    public suspend fun secretsParameters(`value`: Output<String>) {
        this.secretsParameters = value
    }

    /**
     * @param value The name of the SmfDeployment
     */
    @JvmName("kgqvdvdhneunvlou")
    public suspend fun smfDeploymentName(`value`: Output<String>) {
        this.smfDeploymentName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yiufkuovemalisfe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Reference to cluster where the Network Function is deployed
     */
    @JvmName("rxpcrwynlpsmbtru")
    public suspend fun clusterService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterService = mapped
    }

    /**
     * @param value Azure for Operators 5G Core SMF component parameters
     */
    @JvmName("oistajnvejwvxtkg")
    public suspend fun componentParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentParameters = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aocuuhhwuoomhvob")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ypmjucghrxcalfdq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure for Operators 5G Core SMF secrets parameters
     */
    @JvmName("yxbcvomielehlvgt")
    public suspend fun secretsParameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsParameters = mapped
    }

    /**
     * @param value The name of the SmfDeployment
     */
    @JvmName("syicbqcuxfljchcv")
    public suspend fun smfDeploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smfDeploymentName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hutolkgexacrvthx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lnprcsgvsldnbfxi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SmfDeploymentArgs = SmfDeploymentArgs(
        clusterService = clusterService,
        componentParameters = componentParameters,
        location = location,
        resourceGroupName = resourceGroupName,
        secretsParameters = secretsParameters,
        smfDeploymentName = smfDeploymentName,
        tags = tags,
    )
}
