@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin

import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin as operationalStatusResponseToKotlin
import com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [UpfDeployment].
 */
@PulumiTagMarker
public class UpfDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UpfDeploymentArgs = UpfDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UpfDeploymentArgsBuilder.() -> Unit) {
        val builder = UpfDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UpfDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.mobilepacketcore.UpfDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return UpfDeployment(builtJavaResource)
    }
}

/**
 * Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
 * Azure REST API version: 2023-10-15-preview.
 * ## Example Usage
 * ### UpfDeployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var upfDeployment = new AzureNative.MobilePacketCore.UpfDeployment("upfDeployment", new()
 *     {
 *         ClusterService = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster",
 *         ComponentParameters = "{\"global\": {\"registry\": {\"docker\": []}}}",
 *         Location = "eastus",
 *         ResourceGroupName = "rg1",
 *         SecretsParameters = "{\"global\": {\"secret\": {\"secretValue\": []}}}",
 *         UpfDeploymentName = "upfDeployment1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilepacketcore/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilepacketcore.NewUpfDeployment(ctx, "upfDeployment", &mobilepacketcore.UpfDeploymentArgs{
 * 			ClusterService:      pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster"),
 * 			ComponentParameters: pulumi.String("{\"global\": {\"registry\": {\"docker\": []}}}"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			SecretsParameters:   pulumi.String("{\"global\": {\"secret\": {\"secretValue\": []}}}"),
 * 			UpfDeploymentName:   pulumi.String("upfDeployment1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilepacketcore.UpfDeployment;
 * import com.pulumi.azurenative.mobilepacketcore.UpfDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upfDeployment = new UpfDeployment("upfDeployment", UpfDeploymentArgs.builder()
 *             .clusterService("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobilePacketCore/clusterServices/byoCluster")
 *             .componentParameters("{\"global\": {\"registry\": {\"docker\": []}}}")
 *             .location("eastus")
 *             .resourceGroupName("rg1")
 *             .secretsParameters("{\"global\": {\"secret\": {\"secretValue\": []}}}")
 *             .upfDeploymentName("upfDeployment1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilepacketcore:UpfDeployment upfDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobilePacketCore/upfDeployments/{upfDeploymentName}
 * ```
 */
public class UpfDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilepacketcore.UpfDeployment,
) : KotlinCustomResource(javaResource, UpfDeploymentMapper) {
    /**
     * Reference to cluster where the Network Function is deployed
     */
    public val clusterService: Output<String>
        get() = javaResource.clusterService().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core UPF component parameters
     */
    public val componentParameters: Output<String>
        get() = javaResource.componentParameters().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operational status
     */
    public val operationalStatus: Output<OperationalStatusResponse>
        get() = javaResource.operationalStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                operationalStatusResponseToKotlin(args0)
            })
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Release version. This is inherited from the cluster
     */
    public val releaseVersion: Output<String>
        get() = javaResource.releaseVersion().applyValue({ args0 -> args0 })

    /**
     * Azure for Operators 5G Core F secrets parameters
     */
    public val secretsParameters: Output<String>?
        get() = javaResource.secretsParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UpfDeploymentMapper : ResourceMapper<UpfDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilepacketcore.UpfDeployment::class == javaResource::class

    override fun map(javaResource: Resource): UpfDeployment = UpfDeployment(
        javaResource as
            com.pulumi.azurenative.mobilepacketcore.UpfDeployment,
    )
}

/**
 * @see [UpfDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UpfDeployment].
 */
public suspend fun upfDeployment(
    name: String,
    block: suspend UpfDeploymentResourceBuilder.() -> Unit,
): UpfDeployment {
    val builder = UpfDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UpfDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun upfDeployment(name: String): UpfDeployment {
    val builder = UpfDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
