@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Administrative state of the network function
 */
public enum class NetworkFunctionAdministrativeState(
    public val javaValue: com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState> {
    /**
     * Resource has been commissioned
     */
    Commissioned(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState.Commissioned),

    /**
     * Resource has been decommissioned
     */
    Decommissioned(com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState.Decommissioned),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.enums.NetworkFunctionAdministrativeState): NetworkFunctionAdministrativeState =
            NetworkFunctionAdministrativeState.values().first { it.javaValue == javaType }
    }
}
