@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Cluster type (Lab or Production)
 */
public enum class SkuDeploymentType(
    public val javaValue: com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType> {
    /**
     * Production Deployment
     */
    Production(com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType.Production),

    /**
     * Lab Deployment
     */
    Lab(com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType.Lab),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.enums.SkuDeploymentType): SkuDeploymentType = SkuDeploymentType.values().first { it.javaValue == javaType }
    }
}
