@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceNexusAksClusterDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Nexus AKS Cluster specific data.
 * @property customLocationId Custom Location resource ID
 * @property type Cluster Type Definitions
 * Expected value is 'NexusAks'.
 */
public data class ClusterServiceNexusAksClusterDataArgs(
    public val customLocationId: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceNexusAksClusterDataArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceNexusAksClusterDataArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.ClusterServiceNexusAksClusterDataArgs.builder()
            .customLocationId(customLocationId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServiceNexusAksClusterDataArgs].
 */
@PulumiTagMarker
public class ClusterServiceNexusAksClusterDataArgsBuilder internal constructor() {
    private var customLocationId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Custom Location resource ID
     */
    @JvmName("yjfbwqwkowfvgkrw")
    public suspend fun customLocationId(`value`: Output<String>) {
        this.customLocationId = value
    }

    /**
     * @param value Cluster Type Definitions
     * Expected value is 'NexusAks'.
     */
    @JvmName("xfkvspiceuscjaax")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Custom Location resource ID
     */
    @JvmName("cvdtlywvatoimypc")
    public suspend fun customLocationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customLocationId = mapped
    }

    /**
     * @param value Cluster Type Definitions
     * Expected value is 'NexusAks'.
     */
    @JvmName("hyomjevyqggtjjqg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ClusterServiceNexusAksClusterDataArgs =
        ClusterServiceNexusAksClusterDataArgs(
            customLocationId = customLocationId ?: throw PulumiNullFieldException("customLocationId"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
