@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetNssfDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property nssfDeploymentName The name of the NssfDeployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNssfDeploymentPlainArgs(
    public val nssfDeploymentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetNssfDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetNssfDeploymentPlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetNssfDeploymentPlainArgs.builder()
            .nssfDeploymentName(nssfDeploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNssfDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetNssfDeploymentPlainArgsBuilder internal constructor() {
    private var nssfDeploymentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NssfDeployment
     */
    @JvmName("rxptkdptgvgtudqn")
    public suspend fun nssfDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nssfDeploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qduofyggrserhdmb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNssfDeploymentPlainArgs = GetNssfDeploymentPlainArgs(
        nssfDeploymentName = nssfDeploymentName ?: throw PulumiNullFieldException("nssfDeploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
