@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * AO5GC Network Function Resource
 * @property capacity Capacity of the network function in units of 10000.  This represents the session count or the Simultaneously Attached Users (SAU) count as applicable
 * @property deploymentNotes User provided deployment notes.  This is used to optionally provide details about the NF deployment
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property infrastructureElementCount Count of infrastructure elements used by this network function (vCPUs, in units of 8)
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkFunctionAdministrativeState Administrative state of the network function
 * @property networkFunctionOperationalStatus Operational state of the network function
 * @property networkFunctionType Type of network function
 * @property provisioningState The status of the last operation.
 * @property sku Provisioned SKU Value.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property userDescription User provided description
 */
public data class GetNetworkFunctionResult(
    public val capacity: Int? = null,
    public val deploymentNotes: String? = null,
    public val id: String,
    public val infrastructureElementCount: Int,
    public val location: String,
    public val name: String,
    public val networkFunctionAdministrativeState: String,
    public val networkFunctionOperationalStatus: String,
    public val networkFunctionType: String,
    public val provisioningState: String,
    public val sku: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.GetNetworkFunctionResult): GetNetworkFunctionResult = GetNetworkFunctionResult(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            deploymentNotes = javaType.deploymentNotes().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            infrastructureElementCount = javaType.infrastructureElementCount(),
            location = javaType.location(),
            name = javaType.name(),
            networkFunctionAdministrativeState = javaType.networkFunctionAdministrativeState(),
            networkFunctionOperationalStatus = javaType.networkFunctionOperationalStatus(),
            networkFunctionType = javaType.networkFunctionType(),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userDescription = javaType.userDescription().map({ args0 -> args0 }).orElse(null),
        )
    }
}
