@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Operational Status of the resource
 * @property healthCheck Health check results
 * @property workload Status of the deployed workload
 */
public data class OperationalStatusResponse(
    public val healthCheck: String,
    public val workload: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.OperationalStatusResponse): OperationalStatusResponse = OperationalStatusResponse(
            healthCheck = javaType.healthCheck(),
            workload = javaType.workload(),
        )
    }
}
