@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Containerized Network Function (CNF) Qualified Deployment Parameters
 * @property parameters Deployment Parameters
 * @property secrets Deployment secrets
 * @property type Federation Type
 */
public data class QualifiedComponentDeploymentParametersResponse(
    public val parameters: String? = null,
    public val secrets: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.QualifiedComponentDeploymentParametersResponse): QualifiedComponentDeploymentParametersResponse =
            QualifiedComponentDeploymentParametersResponse(
                parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
                secrets = javaType.secrets().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
