@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin

import com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseDefaultIngestionSettings
import com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseMetrics
import com.pulumi.azurenative.monitor.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.monitor.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseDefaultIngestionSettings.Companion.toKotlin as azureMonitorWorkspaceResponseDefaultIngestionSettingsToKotlin
import com.pulumi.azurenative.monitor.kotlin.outputs.AzureMonitorWorkspaceResponseMetrics.Companion.toKotlin as azureMonitorWorkspaceResponseMetricsToKotlin
import com.pulumi.azurenative.monitor.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.monitor.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AzureMonitorWorkspace].
 */
@PulumiTagMarker
public class AzureMonitorWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureMonitorWorkspaceArgs = AzureMonitorWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureMonitorWorkspaceArgsBuilder.() -> Unit) {
        val builder = AzureMonitorWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureMonitorWorkspace {
        val builtJavaResource =
            com.pulumi.azurenative.monitor.AzureMonitorWorkspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureMonitorWorkspace(builtJavaResource)
    }
}

/**
 * An Azure Monitor Workspace definition
 * Azure REST API version: 2023-04-03. Prior API version in Azure Native 1.x: 2021-06-03-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create or update an Azure Monitor Workspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureMonitorWorkspace = new AzureNative.Monitor.AzureMonitorWorkspace("azureMonitorWorkspace", new()
 *     {
 *         AzureMonitorWorkspaceName = "myAzureMonitorWorkspace",
 *         Location = "eastus",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/monitor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := monitor.NewAzureMonitorWorkspace(ctx, "azureMonitorWorkspace", &monitor.AzureMonitorWorkspaceArgs{
 * 			AzureMonitorWorkspaceName: pulumi.String("myAzureMonitorWorkspace"),
 * 			Location:                  pulumi.String("eastus"),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.monitor.AzureMonitorWorkspace;
 * import com.pulumi.azurenative.monitor.AzureMonitorWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureMonitorWorkspace = new AzureMonitorWorkspace("azureMonitorWorkspace", AzureMonitorWorkspaceArgs.builder()
 *             .azureMonitorWorkspaceName("myAzureMonitorWorkspace")
 *             .location("eastus")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:monitor:AzureMonitorWorkspace myAzureMonitorWorkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Monitor/accounts/{azureMonitorWorkspaceName}
 * ```
 */
public class AzureMonitorWorkspace internal constructor(
    override val javaResource: com.pulumi.azurenative.monitor.AzureMonitorWorkspace,
) : KotlinCustomResource(javaResource, AzureMonitorWorkspaceMapper) {
    /**
     * The immutable Id of the Azure Monitor Workspace. This property is read-only.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The Data Collection Rule and Endpoint used for ingestion by default.
     */
    public val defaultIngestionSettings: Output<AzureMonitorWorkspaceResponseDefaultIngestionSettings>
        get() = javaResource.defaultIngestionSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                azureMonitorWorkspaceResponseDefaultIngestionSettingsToKotlin(args0)
            })
        })

    /**
     * Resource entity tag (ETag)
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Properties related to the metrics container in the Azure Monitor Workspace
     */
    public val metrics: Output<AzureMonitorWorkspaceResponseMetrics>
        get() = javaResource.metrics().applyValue({ args0 ->
            args0.let({ args0 ->
                azureMonitorWorkspaceResponseMetricsToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * The provisioning state of the Azure Monitor Workspace. Set to Succeeded if everything is healthy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets or sets allow or disallow public network access to Azure Monitor Workspace
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureMonitorWorkspaceMapper : ResourceMapper<AzureMonitorWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.monitor.AzureMonitorWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): AzureMonitorWorkspace =
        AzureMonitorWorkspace(javaResource as com.pulumi.azurenative.monitor.AzureMonitorWorkspace)
}

/**
 * @see [AzureMonitorWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureMonitorWorkspace].
 */
public suspend fun azureMonitorWorkspace(
    name: String,
    block: suspend AzureMonitorWorkspaceResourceBuilder.() -> Unit,
): AzureMonitorWorkspace {
    val builder = AzureMonitorWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureMonitorWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureMonitorWorkspace(name: String): AzureMonitorWorkspace {
    val builder = AzureMonitorWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
