@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin

import com.pulumi.azurenative.monitor.MonitorFunctions.getAzureMonitorWorkspacePlain
import com.pulumi.azurenative.monitor.MonitorFunctions.getPipelineGroupPlain
import com.pulumi.azurenative.monitor.kotlin.inputs.GetAzureMonitorWorkspacePlainArgs
import com.pulumi.azurenative.monitor.kotlin.inputs.GetAzureMonitorWorkspacePlainArgsBuilder
import com.pulumi.azurenative.monitor.kotlin.inputs.GetPipelineGroupPlainArgs
import com.pulumi.azurenative.monitor.kotlin.inputs.GetPipelineGroupPlainArgsBuilder
import com.pulumi.azurenative.monitor.kotlin.outputs.GetAzureMonitorWorkspaceResult
import com.pulumi.azurenative.monitor.kotlin.outputs.GetPipelineGroupResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.monitor.kotlin.outputs.GetAzureMonitorWorkspaceResult.Companion.toKotlin as getAzureMonitorWorkspaceResultToKotlin
import com.pulumi.azurenative.monitor.kotlin.outputs.GetPipelineGroupResult.Companion.toKotlin as getPipelineGroupResultToKotlin

public object MonitorFunctions {
    /**
     * Returns the specified Azure Monitor Workspace
     * Azure REST API version: 2023-04-03.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return An Azure Monitor Workspace definition
     */
    public suspend fun getAzureMonitorWorkspace(argument: GetAzureMonitorWorkspacePlainArgs): GetAzureMonitorWorkspaceResult =
        getAzureMonitorWorkspaceResultToKotlin(getAzureMonitorWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getAzureMonitorWorkspace].
     * @param azureMonitorWorkspaceName The name of the Azure Monitor Workspace. The name is case insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Monitor Workspace definition
     */
    public suspend fun getAzureMonitorWorkspace(
        azureMonitorWorkspaceName: String,
        resourceGroupName: String,
    ): GetAzureMonitorWorkspaceResult {
        val argument = GetAzureMonitorWorkspacePlainArgs(
            azureMonitorWorkspaceName = azureMonitorWorkspaceName,
            resourceGroupName = resourceGroupName,
        )
        return getAzureMonitorWorkspaceResultToKotlin(getAzureMonitorWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureMonitorWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;monitor&#46;kotlin&#46;inputs&#46;GetAzureMonitorWorkspacePlainArgs].
     * @return An Azure Monitor Workspace definition
     */
    public suspend fun getAzureMonitorWorkspace(argument: suspend GetAzureMonitorWorkspacePlainArgsBuilder.() -> Unit): GetAzureMonitorWorkspaceResult {
        val builder = GetAzureMonitorWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureMonitorWorkspaceResultToKotlin(getAzureMonitorWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the specific pipeline group instance.
     * Azure REST API version: 2023-10-01-preview.
     * @param argument null
     * @return A pipeline group definition.
     */
    public suspend fun getPipelineGroup(argument: GetPipelineGroupPlainArgs): GetPipelineGroupResult =
        getPipelineGroupResultToKotlin(getPipelineGroupPlain(argument.toJava()).await())

    /**
     * @see [getPipelineGroup].
     * @param pipelineGroupName The name of pipeline group. The name is case insensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A pipeline group definition.
     */
    public suspend fun getPipelineGroup(pipelineGroupName: String, resourceGroupName: String): GetPipelineGroupResult {
        val argument = GetPipelineGroupPlainArgs(
            pipelineGroupName = pipelineGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getPipelineGroupResultToKotlin(getPipelineGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getPipelineGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;monitor&#46;kotlin&#46;inputs&#46;GetPipelineGroupPlainArgs].
     * @return A pipeline group definition.
     */
    public suspend fun getPipelineGroup(argument: suspend GetPipelineGroupPlainArgsBuilder.() -> Unit): GetPipelineGroupResult {
        val builder = GetPipelineGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineGroupResultToKotlin(getPipelineGroupPlain(builtArgument.toJava()).await())
    }
}
