@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of exporter.
 */
public enum class ExporterType(
    public val javaValue: com.pulumi.azurenative.monitor.enums.ExporterType,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.ExporterType> {
    /**
     * Export logs to Azure Monitor Workspace.
     */
    AzureMonitorWorkspaceLogs(com.pulumi.azurenative.monitor.enums.ExporterType.AzureMonitorWorkspaceLogs),

    /**
     * Export data to another pipeline group instance.
     */
    PipelineGroup(com.pulumi.azurenative.monitor.enums.ExporterType.PipelineGroup),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.ExporterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.ExporterType): ExporterType =
            ExporterType.values().first { it.javaValue == javaType }
    }
}
