@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of pipeline
 */
public enum class PipelineType(
    public val javaValue: com.pulumi.azurenative.monitor.enums.PipelineType,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.PipelineType> {
    /**
     * Pipeline for logs telemetry.
     */
    Logs(com.pulumi.azurenative.monitor.enums.PipelineType.Logs),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.PipelineType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.PipelineType): PipelineType =
            PipelineType.values().first { it.javaValue == javaType }
    }
}
