@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of processor.
 */
public enum class ProcessorType(
    public val javaValue: com.pulumi.azurenative.monitor.enums.ProcessorType,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.ProcessorType> {
    /**
     * Batch processor.
     */
    Batch(com.pulumi.azurenative.monitor.enums.ProcessorType.Batch),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.ProcessorType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.ProcessorType): ProcessorType = ProcessorType.values().first { it.javaValue == javaType }
    }
}
