@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets allow or disallow public network access to Azure Monitor Workspace
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.monitor.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.monitor.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.monitor.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.PublicNetworkAccess): PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
