@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of receiver.
 */
public enum class ReceiverType(
    public val javaValue: com.pulumi.azurenative.monitor.enums.ReceiverType,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.ReceiverType> {
    /**
     * Linux syslog.
     */
    Syslog(com.pulumi.azurenative.monitor.enums.ReceiverType.Syslog),

    /**
     * Receives data from azure monitor agent receiver.
     */
    Ama(com.pulumi.azurenative.monitor.enums.ReceiverType.Ama),

    /**
     * Receives data from another pipeline group.
     */
    PipelineGroup(com.pulumi.azurenative.monitor.enums.ReceiverType.PipelineGroup),

    /**
     * Receives data from a OTLP collector.
     */
    OTLP(com.pulumi.azurenative.monitor.enums.ReceiverType.OTLP),

    /**
     * Receives data from an UDP collector.
     */
    UDP(com.pulumi.azurenative.monitor.enums.ReceiverType.UDP),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.ReceiverType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.ReceiverType): ReceiverType =
            ReceiverType.values().first { it.javaValue == javaType }
    }
}
