@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encoding of the stream being received.
 */
public enum class StreamEncodingType(
    public val javaValue: com.pulumi.azurenative.monitor.enums.StreamEncodingType,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.StreamEncodingType> {
    /**
     * No encoding validation. Treats the file as a stream of raw bytes.
     */
    Nop(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Nop),

    /**
     * UTF-8 encoding.
     */
    Utf_8(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Utf_8),

    /**
     * UTF-16 encoding with little-endian byte order.
     */
    Utf_16le(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Utf_16le),

    /**
     * UTF-16 encoding with little-endian byte order.
     */
    Utf_16be(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Utf_16be),

    /**
     * ASCII encoding.
     */
    Ascii(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Ascii),

    /**
     * The Big5 Chinese character encoding.
     */
    Big5(com.pulumi.azurenative.monitor.enums.StreamEncodingType.Big5),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.StreamEncodingType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.StreamEncodingType): StreamEncodingType = StreamEncodingType.values().first { it.javaValue == javaType }
    }
}
