@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protocol to parse syslog messages. Default rfc3164
 */
public enum class SyslogProtocol(
    public val javaValue: com.pulumi.azurenative.monitor.enums.SyslogProtocol,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.enums.SyslogProtocol> {
    /**
     * rfc3164 protocol.
     */
    Rfc3164(com.pulumi.azurenative.monitor.enums.SyslogProtocol.Rfc3164),

    /**
     * rfc5424 protocol.
     */
    Rfc5424(com.pulumi.azurenative.monitor.enums.SyslogProtocol.Rfc5424),
    ;

    override fun toJava(): com.pulumi.azurenative.monitor.enums.SyslogProtocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.monitor.enums.SyslogProtocol): SyslogProtocol = SyslogProtocol.values().first { it.javaValue == javaType }
    }
}
