@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsApiConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Monitor Workspace Logs Api configurations.
 * @property dataCollectionEndpointUrl Data collection endpoint ingestion url.
 * @property dataCollectionRule Data Collection Rule (DCR) immutable id.
 * @property schema The schema mapping for incoming data.
 * @property stream Stream name in destination. Azure Monitor stream is related to the destination table.
 */
public data class AzureMonitorWorkspaceLogsApiConfigArgs(
    public val dataCollectionEndpointUrl: Output<String>,
    public val dataCollectionRule: Output<String>,
    public val schema: Output<SchemaMapArgs>,
    public val stream: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsApiConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsApiConfigArgs =
        com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsApiConfigArgs.builder()
            .dataCollectionEndpointUrl(dataCollectionEndpointUrl.applyValue({ args0 -> args0 }))
            .dataCollectionRule(dataCollectionRule.applyValue({ args0 -> args0 }))
            .schema(schema.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stream(stream.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureMonitorWorkspaceLogsApiConfigArgs].
 */
@PulumiTagMarker
public class AzureMonitorWorkspaceLogsApiConfigArgsBuilder internal constructor() {
    private var dataCollectionEndpointUrl: Output<String>? = null

    private var dataCollectionRule: Output<String>? = null

    private var schema: Output<SchemaMapArgs>? = null

    private var stream: Output<String>? = null

    /**
     * @param value Data collection endpoint ingestion url.
     */
    @JvmName("vrqrcgshsfjilpsb")
    public suspend fun dataCollectionEndpointUrl(`value`: Output<String>) {
        this.dataCollectionEndpointUrl = value
    }

    /**
     * @param value Data Collection Rule (DCR) immutable id.
     */
    @JvmName("frlmfploiokstegi")
    public suspend fun dataCollectionRule(`value`: Output<String>) {
        this.dataCollectionRule = value
    }

    /**
     * @param value The schema mapping for incoming data.
     */
    @JvmName("grtywdjvqnebyyme")
    public suspend fun schema(`value`: Output<SchemaMapArgs>) {
        this.schema = value
    }

    /**
     * @param value Stream name in destination. Azure Monitor stream is related to the destination table.
     */
    @JvmName("soqqjpcsayvxmhwh")
    public suspend fun stream(`value`: Output<String>) {
        this.stream = value
    }

    /**
     * @param value Data collection endpoint ingestion url.
     */
    @JvmName("tckijakgepirnnpt")
    public suspend fun dataCollectionEndpointUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataCollectionEndpointUrl = mapped
    }

    /**
     * @param value Data Collection Rule (DCR) immutable id.
     */
    @JvmName("qowxpycntvnxbjij")
    public suspend fun dataCollectionRule(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataCollectionRule = mapped
    }

    /**
     * @param value The schema mapping for incoming data.
     */
    @JvmName("kujdtoemyfykjnmv")
    public suspend fun schema(`value`: SchemaMapArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The schema mapping for incoming data.
     */
    @JvmName("dthpqssglekwktgb")
    public suspend fun schema(argument: suspend SchemaMapArgsBuilder.() -> Unit) {
        val toBeMapped = SchemaMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value Stream name in destination. Azure Monitor stream is related to the destination table.
     */
    @JvmName("rxdwkidbdvsxbwqt")
    public suspend fun stream(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stream = mapped
    }

    internal fun build(): AzureMonitorWorkspaceLogsApiConfigArgs =
        AzureMonitorWorkspaceLogsApiConfigArgs(
            dataCollectionEndpointUrl = dataCollectionEndpointUrl ?: throw
                PulumiNullFieldException("dataCollectionEndpointUrl"),
            dataCollectionRule = dataCollectionRule ?: throw PulumiNullFieldException("dataCollectionRule"),
            schema = schema ?: throw PulumiNullFieldException("schema"),
            stream = stream ?: throw PulumiNullFieldException("stream"),
        )
}
