@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsExporterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Monitor Workspace Logs specific configurations.
 * @property api API configurations for Azure Monitor workspace exporter.
 * @property cache Cache configurations.
 * @property concurrency Concurrency configuration for the exporter.
 */
public data class AzureMonitorWorkspaceLogsExporterArgs(
    public val api: Output<AzureMonitorWorkspaceLogsApiConfigArgs>,
    public val cache: Output<CacheConfigurationArgs>? = null,
    public val concurrency: Output<ConcurrencyConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsExporterArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsExporterArgs = com.pulumi.azurenative.monitor.inputs.AzureMonitorWorkspaceLogsExporterArgs.builder()
        .api(api.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .cache(cache?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .concurrency(concurrency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AzureMonitorWorkspaceLogsExporterArgs].
 */
@PulumiTagMarker
public class AzureMonitorWorkspaceLogsExporterArgsBuilder internal constructor() {
    private var api: Output<AzureMonitorWorkspaceLogsApiConfigArgs>? = null

    private var cache: Output<CacheConfigurationArgs>? = null

    private var concurrency: Output<ConcurrencyConfigurationArgs>? = null

    /**
     * @param value API configurations for Azure Monitor workspace exporter.
     */
    @JvmName("bwurrcyjlyutwyfq")
    public suspend fun api(`value`: Output<AzureMonitorWorkspaceLogsApiConfigArgs>) {
        this.api = value
    }

    /**
     * @param value Cache configurations.
     */
    @JvmName("ybwuuoeghiguypcf")
    public suspend fun cache(`value`: Output<CacheConfigurationArgs>) {
        this.cache = value
    }

    /**
     * @param value Concurrency configuration for the exporter.
     */
    @JvmName("qxwrlnixhcveaeoq")
    public suspend fun concurrency(`value`: Output<ConcurrencyConfigurationArgs>) {
        this.concurrency = value
    }

    /**
     * @param value API configurations for Azure Monitor workspace exporter.
     */
    @JvmName("unnnnjsgsjndmdkf")
    public suspend fun api(`value`: AzureMonitorWorkspaceLogsApiConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.api = mapped
    }

    /**
     * @param argument API configurations for Azure Monitor workspace exporter.
     */
    @JvmName("warfsdavtwmkpxat")
    public suspend fun api(argument: suspend AzureMonitorWorkspaceLogsApiConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMonitorWorkspaceLogsApiConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.api = mapped
    }

    /**
     * @param value Cache configurations.
     */
    @JvmName("tusjcqdqpbvuucaq")
    public suspend fun cache(`value`: CacheConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cache = mapped
    }

    /**
     * @param argument Cache configurations.
     */
    @JvmName("qknlgybgayaqgagf")
    public suspend fun cache(argument: suspend CacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CacheConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param value Concurrency configuration for the exporter.
     */
    @JvmName("gnaadjxbmimqryma")
    public suspend fun concurrency(`value`: ConcurrencyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrency = mapped
    }

    /**
     * @param argument Concurrency configuration for the exporter.
     */
    @JvmName("axfngllqujmeaxuf")
    public suspend fun concurrency(argument: suspend ConcurrencyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ConcurrencyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.concurrency = mapped
    }

    internal fun build(): AzureMonitorWorkspaceLogsExporterArgs =
        AzureMonitorWorkspaceLogsExporterArgs(
            api = api ?: throw PulumiNullFieldException("api"),
            cache = cache,
            concurrency = concurrency,
        )
}
