@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin.inputs

import com.pulumi.azurenative.monitor.inputs.BatchProcessorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Batch processor.
 * @property batchSize Size of the batch.
 * @property timeout Timeout in milliseconds.
 */
public data class BatchProcessorArgs(
    public val batchSize: Output<Int>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.monitor.inputs.BatchProcessorArgs> {
    override fun toJava(): com.pulumi.azurenative.monitor.inputs.BatchProcessorArgs =
        com.pulumi.azurenative.monitor.inputs.BatchProcessorArgs.builder()
            .batchSize(batchSize?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BatchProcessorArgs].
 */
@PulumiTagMarker
public class BatchProcessorArgsBuilder internal constructor() {
    private var batchSize: Output<Int>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value Size of the batch.
     */
    @JvmName("xwuiphvvkiabsifx")
    public suspend fun batchSize(`value`: Output<Int>) {
        this.batchSize = value
    }

    /**
     * @param value Timeout in milliseconds.
     */
    @JvmName("lrmbvuegenhhofwt")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Size of the batch.
     */
    @JvmName("pglhljeshhyaeqpm")
    public suspend fun batchSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchSize = mapped
    }

    /**
     * @param value Timeout in milliseconds.
     */
    @JvmName("jtbpvpgpykfelxsh")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): BatchProcessorArgs = BatchProcessorArgs(
        batchSize = batchSize,
        timeout = timeout,
    )
}
